#!/bin/sh
set -e

RED='\033[0;31m'
CYAN='\033[0;36m'
END='\033[0m'

function print_usage() {
    echo -e "\tusage : $0 (mtd number) (param bytes) (hw_param path) (isp_param path)"
    exit;
}

function print_err() {
    echo -e "${RED}error, $1${END} ... exit."
    print_usage;
}

if [ "$#" != "4" -o "${1:0:2}" == "-h" ]; then print_usage; fi

MTD_NUM="$1"
PARAM_SIZE="$2"
HW_PARAM="$3"
ISP_PARAM="$4"

if [ "$MTD_NUM" -eq "$MTD_NUM" ] 2>/dev/null; then      echo "" >> /dev/null;
else                                                    print_err "$MTD_NUM is not a number"; fi
if [ "$PARAM_SIZE" -eq "$PARAM_SIZE" ] 2>/dev/null; then    echo "" >> /dev/null;
else                                                    print_err "$PARAM_SIZE is not a number"; fi

let max_mtd=$(cat /proc/mtd | grep -c mtd)-1
if [ "$MTD_NUM" -lt 0 -o "$MTD_NUM" -gt $max_mtd ]; then print_err "mtd number '$MTD_NUM' is out of range($max_mtd)."; fi

let max_size=$(cat /sys/block/mtdblock$MTD_NUM/device/size)
if [ "$PARAM_SIZE" -lt 4096 -o "$PARAM_SIZE" -gt "$max_size" ]; then print_err "mtd size '$PARAM_SIZE' is out of range($max_size)."; fi
if [ ! -e "$HW_PARAM" ]; then print_err "'$HW_PARAM' is not exist!! "; fi
if [ ! -e "$ISP_PARAM" ]; then print_err "'$ISP_PARAM' is not exist!! "; fi

hw_size=$(wc -c $HW_PARAM | awk '{print $1}')
isp_size=$(wc -c $ISP_PARAM | awk '{print $1}')

echo -e "\tvideocore parameter update"
echo -e "\tmtd num\t\t: $MTD_NUM "
echo -e "\tmtd size\t: $PARAM_SIZE "
echo -e "\thw param\t: $HW_PARAM ($hw_size bytes)"
echo -e "\tisp param\t: $ISP_PARAM ($isp_size bytes)"

# to check videocore img type whether supports updating the user parameters.
mtd_debug read /dev/mtd$MTD_NUM 0 4 img_type.read > /dev/null
read_data="$(cat img_type.read)"
rm img_type.read
if [ "$read_data" == "IHWS" ]; then
    echo -e "\t ${CYAN}(read img_type supports updating User Parameter.)${END}"
else
    echo -e "\t ${RED}(updating User Parameter is not applicable for this img type.)${END}"
    exit
fi

# block ease 
mtd_debug erase /dev/mtd$MTD_NUM 0 $PARAM_SIZE

# write
mtd_debug write /dev/mtd$MTD_NUM 0 $hw_size $HW_PARAM
mtd_debug write /dev/mtd$MTD_NUM 1024 $isp_size $ISP_PARAM

# test to check
#mtd_debug read /dev/mtd$MTD_NUM 0 $PARAM_SIZE vcorepart.read