#!/bin/sh

CAM_ID_PNCODE=`/usr/local/bin/GetPnCodeStr -o19 -l2`
CAM_ID_PNCODE_FIRST=`/usr/local/bin/GetPnCodeStr -o19 -l1`
OEM_ID_PNCODE=`/usr/local/bin/GetPnCodeStr -o29 -l2`
IRIS_PNCODE=`/usr/local/bin/GetPnCodeStr -o25 -l1`
MIRROR_FLIP_PNCODE=`/usr/local/bin/GetPnCodeStr -o34 -l1`
DUMPPARAMFILE="/tmp/dumpparam.bin"
CPUID_PNCODE=`/usr/local/bin/GetPnCodeStr -o8 -l1`
VOUT_PNCODE=`/usr/local/bin/GetPnCodeStr -o27 -l1`
TDN_PNCODE=`/usr/local/bin/GetPnCodeStr -o26 -l1`
ADDITIONAL_PNCODE=`/usr/local/bin/GetPnCodeStr -o51 -l1`
HW_PARAM_NAME="/etc/hw_param.bin"
ISP_PARAM_NAME="/etc/isp_param.bin"
ZSPE_BIT=0

dd if=/dev/zero count=1 bs=65536 | tr '\000' '\377' > $DUMPPARAMFILE
dd if=$HW_PARAM_NAME of=$DUMPPARAMFILE bs=1024 seek=0 conv=notrunc
dd if=$ISP_PARAM_NAME of=$DUMPPARAMFILE bs=1024 seek=1 conv=notrunc

#if [[ -f "/etc/hw_param_OEM_$OEM_ID_PNCODE.bin" && -f "/etc/isp_param_OEM_$OEM_ID_PNCODE.bin" ]]; then
#        /usr/sbin/param_update.sh 1 131072 /etc/hw_param_OEM_$OEM_ID_PNCODE.bin /etc/isp_param_OEM_$OEM_ID_PNCODE.bin
#elif [[ -f "/etc/hw_param_$CAM_ID_PNCODE.bin" && -f "/etc/isp_param_$CAM_ID_PNCODE.bin" ]]; then
#        /usr/sbin/param_update.sh 1 131072 /etc/hw_param_$CAM_ID_PNCODE.bin /etc/isp_param_$CAM_ID_PNCODE.bin
#elif [[ $CAM_ID_PNCODE_FIRST != 8 ]]; then
#        /usr/sbin/param_update.sh 1 131072 /etc/hw_param_yuv422_to_mipi.bin /etc/isp_param_yuv422_to_mipi.bin
#else   # CAM_ID_PNCODE 8A, 8B, ...(SSPR=0)
#        /usr/sbin/param_update.sh 1 131072 /etc/hw_param.bin /etc/isp_param.bin
#fi
/opt/nss/bin/videocoreparamedit ZCAM=-a$CAM_ID_PNCODE $DUMPPARAMFILE

if [ $CAM_ID_PNCODE_FIRST != "8" ]; then
	/opt/nss/bin/videocoreparamedit SSON=0,UYVC=0,DI0M=7,DI0F=30,DI0W=1920,DI0H=1080,LYHP=1920,LYVP=1080,MPHS=26,X100=1 $DUMPPARAMFILE
fi

if [ $IRIS_PNCODE == "P" ] || [ $IRIS_PNCODE == "p" ]; then
	/opt/nss/bin/videocoreparamedit IRIT=2,IRIO=0,IRIC=255 $DUMPPARAMFILE
fi
	
#if [ $MIRROR_FLIP_PNCODE == "0" ]; then
#	/opt/nss/bin/videocoreparamedit IMMR=0,IMFP=0 $DUMPPARAMFILE
#elif [ $MIRROR_FLIP_PNCODE == "1" ]; then
#	/opt/nss/bin/videocoreparamedit IMMR=0,IMFP=1 $DUMPPARAMFILE
#elif [ $MIRROR_FLIP_PNCODE == "2" ]; then
#	/opt/nss/bin/videocoreparamedit IMMR=1,IMFP=0 $DUMPPARAMFILE
#elif [ $MIRROR_FLIP_PNCODE == "3" ]; then
#	/opt/nss/bin/videocoreparamedit IMMR=1,IMFP=1 $DUMPPARAMFILE
#fi


if [ $CAM_ID_PNCODE == "2J" ] || [ $CAM_ID_PNCODE == "2z" ] || [ $CAM_ID_PNCODE == "2H" ] || [ $CAM_ID_PNCODE == "2C" ] || [ $CAM_ID_PNCODE == "2c" ] || [ $CAM_ID_PNCODE == "2D" ] || [ $CAM_ID_PNCODE == "2d" ] || [ $CAM_ID_PNCODE == "2E" ] || [ $CAM_ID_PNCODE == "2e" ] || [ $CAM_ID_PNCODE == "2i" ]; then
	/opt/nss/bin/videocoreparamedit SSON=0,UYVC=0,DI0M=7,DI0F=60,DI0W=1920,DI0H=1080,LYHP=1920,LYVP=1080,MPHS=26,X100=1 $DUMPPARAMFILE
elif [ $CAM_ID_PNCODE == "3G" ] || [ $CAM_ID_PNCODE == "36" ] || [ $CAM_ID_PNCODE == "38" ] || [ $CAM_ID_PNCODE == "3P" ] || [ $CAM_ID_PNCODE == "34" ] || [ $CAM_ID_PNCODE == "3F" ] || [ $CAM_ID_PNCODE == "3f" ] || [ $CAM_ID_PNCODE == "4E" ] || [ $CAM_ID_PNCODE == "4e" ] || [ $CAM_ID_PNCODE == "4B" ] || [ $CAM_ID_PNCODE == "4T" ] || [ $CAM_ID_PNCODE == "4K" ]; then
	/opt/nss/bin/videocoreparamedit SSON=0,UYVC=0,DI0M=7,DI0F=30,DI0W=2560,DI0H=1440,LYHP=2560,LYVP=1440,MPHS=26,X100=1 $DUMPPARAMFILE
elif [ $CAM_ID_PNCODE == "4A" ] || [ $CAM_ID_PNCODE == "4m" ] || [ $CAM_ID_PNCODE == "4O" ] || [ $CAM_ID_PNCODE == "4z" ] || [ $CAM_ID_PNCODE == "4H" ] || [ $CAM_ID_PNCODE == "4L" ]; then
	/opt/nss/bin/videocoreparamedit SSON=0,UYVC=0,DI0M=7,DI0F=30,DI0W=3840,DI0H=2160,LYHP=3840,LYVP=2160,MPHS=26,X100=1 $DUMPPARAMFILE
elif [ $CAM_ID_PNCODE == "4d" ] || [ $CAM_ID_PNCODE == "4D" ] || [ $CAM_ID_PNCODE == "4c" ]; then
	/opt/nss/bin/videocoreparamedit SSON=0,UYVC=0,DI0M=7,DI0F=30,DI0W=640,DI0H=480,LYHP=640,LYVP=480,MPHS=26,X100=1 $DUMPPARAMFILE
elif [ $CAM_ID_PNCODE == "4a" ] || [ $CAM_ID_PNCODE == "47" ] || [ $CAM_ID_PNCODE == "49" ]; then
	/opt/nss/bin/videocoreparamedit SSON=0,UYVC=0,DI0M=7,DI0F=30,DI0W=1280,DI0H=1024,LYHP=1280,LYVP=1024,MPHS=26,X100=1 $DUMPPARAMFILE
elif [ $CAM_ID_PNCODE == "4b" ] || [ $CAM_ID_PNCODE == "45" ]; then
	/opt/nss/bin/videocoreparamedit SSON=0,UYVC=0,DI0M=7,DI0F=30,DI0W=1280,DI0H=720,LYHP=1280,LYVP=720,MPHS=26,X100=1 $DUMPPARAMFILE
elif [ $CAM_ID_PNCODE == "2f" ]; then
	/opt/nss/bin/videocoreparamedit SSON=0,UYVC=0,DI0M=7,DI0F=60,DI0W=1280,DI0H=1024,LYHP=1280,LYVP=1024,MPHS=26,X100=1 $DUMPPARAMFILE
elif [ $CAM_ID_PNCODE == "2g" ]; then
	/opt/nss/bin/videocoreparamedit SSON=0,UYVC=0,DI0M=7,DI0F=60,DI0W=1280,DI0H=720,LYHP=1280,LYVP=720,MPHS=26,X100=1 $DUMPPARAMFILE
elif [ $CAM_ID_PNCODE == "2h" ]; then
	/opt/nss/bin/videocoreparamedit SSON=0,UYVC=0,DI0M=7,DI0F=60,DI0W=640,DI0H=480,LYHP=640,LYVP=480,MPHS=26,X100=1 $DUMPPARAMFILE
elif [ $CAM_ID_PNCODE == "8G" ]; then
	/opt/nss/bin/videocoreparamedit SSPR=4 $DUMPPARAMFILE
elif [ $CAM_ID_PNCODE == "8D" ]; then
	/opt/nss/bin/videocoreparamedit SSPR=8 $DUMPPARAMFILE
elif [ $CAM_ID_PNCODE == "8O" ]; then
        /opt/nss/bin/videocoreparamedit SSPR=51 $DUMPPARAMFILE
elif [ $CAM_ID_PNCODE == "8P" ] || [ $CAM_ID_PNCODE == "8p" ] || [ $CAM_ID_PNCODE == "8o" ]; then
        /opt/nss/bin/videocoreparamedit SSPR=42 $DUMPPARAMFILE
elif [ $CAM_ID_PNCODE == "8I" ]; then
        /opt/nss/bin/videocoreparamedit SSPR=9 $DUMPPARAMFILE
elif [ $CAM_ID_PNCODE == "8U" ]; then
        /opt/nss/bin/videocoreparamedit SSPR=5 $DUMPPARAMFILE
elif [ $CAM_ID_PNCODE == "8c" ] || [ $CAM_ID_PNCODE == "8d" ] || [ $CAM_ID_PNCODE == "8q" ] || [ $CAM_ID_PNCODE == "8s" ]; then
        /opt/nss/bin/videocoreparamedit SSPR=31 $DUMPPARAMFILE
elif [ $CAM_ID_PNCODE == "8e" ] || [ $CAM_ID_PNCODE == "8f" ] || [ $CAM_ID_PNCODE == "8r" ] || [ $CAM_ID_PNCODE == "8t" ] || [ $CAM_ID_PNCODE == "8u" ]; then
        /opt/nss/bin/videocoreparamedit SSPR=2 $DUMPPARAMFILE
fi

if [ $VOUT_PNCODE == "Z" ]; then
	/opt/nss/bin/videocoreparamedit AOUT=0,OCVB=0 $DUMPPARAMFILE
fi

if [ $OEM_ID_PNCODE == "2E" ] || [ $OEM_ID_PNCODE == "2e" ]; then
	/opt/nss/bin/videocoreparamedit OCVB=4 $DUMPPARAMFILE
fi	

if [ $CPUID_PNCODE == "U" ] || [ $CPUID_PNCODE == "V" ]; then
	/opt/nss/bin/videocoreparamedit YCSZ=43 $DUMPPARAMFILE
fi

dec_value=$(echo $((0x$TDN_PNCODE)))
first_bit=$((dec_value         & 0x1))       # bit0 TDN Filter
second_bit=$(((dec_value >> 1) & 0x1))       # bit1 CDS Sensor
third_bit=$(((dec_value >> 2) & 0x1))        # bit2 CDS Polarity
fourth_bit=$(((dec_value >> 3) & 0x1))       # bit3 LED Type

if [ "$first_bit" -eq 1 ]; then
  /opt/nss/bin/videocoreparamedit TNG1=1,TNG2=0 $DUMPPARAMFILE
else
  /opt/nss/bin/videocoreparamedit TNG1=0,TNG2=1 $DUMPPARAMFILE
fi

if [ "$fourth_bit" -eq 1 ]; then
  /opt/nss/bin/videocoreparamedit IRLT=4 $DUMPPARAMFILE
else
  /opt/nss/bin/videocoreparamedit IRLT=1 $DUMPPARAMFILE
fi

if [ $TDN_PNCODE == "0" ]; then
	/opt/nss/bin/videocoreparamedit IRLT=0 $DUMPPARAMFILE
fi		

if [ $ADDITIONAL_PNCODE -eq "2" ]; then
    # ZSPE_BIT 0th bit ON
    ZSPE_BIT=$((ZSPE_BIT | 0x0001))
else
    # ZSPEBIT 0th bit OFF
    ZSPE_BIT=$((ZSPE_BIT & ~0x0001))
fi
/opt/nss/bin/videocoreparamedit ZSPE=$ZSPE_BIT $DUMPPARAMFILE

/usr/sbin/mtd_debug erase /dev/mtd1 0 65536
/usr/sbin/mtd_debug write /dev/mtd1 0 65536 $DUMPPARAMFILE
