#!/bin/sh
#
# F/W update script for ramdisk based FlexWATCH linux system
#
# 							2016-04-21 Gil Jin Yang
#################################################################################

echo "*********************************************************************************"
echo "* F/W update start"
echo "*********************************************************************************"
. /fw-work/fwup-function

UBOOT_IMAGE=`ls /fw-work/u-boot*.bin | tail -n 1`
KERNEL_IMAGE=`ls /fw-work/kernel*.gz | tail -n 1`
DEFCFG_IMAGE=`ls /fw-work/defcfg*.tar.gz | tail -n 1`
CFGBASE_IMAGE=`ls /fw-work/cfg_base.ubifs | tail -n 1`
VIDEOCORE_IMAGE=`ls /fw-work/videocore.gz | tail -n 1`

if [ "$CFGBASE_IMAGE" != "" ]; then
	umount /mnt/cfg
	if [ $? != 0 ]; then
		write_firmup_state 40 "Unmounting cfg partition failed"
		exit 1
	fi
        write_firmup_state 40 "Update cfgbase image"
        update_cfgbase_image $CFGBASE_IMAGE 40 45
fi
if [ "$UBOOT_IMAGE" != "" ]; then
	write_firmup_state 45 "Update uboot image"
	update_uboot_image $UBOOT_IMAGE 45 49
fi
if [ "$KERNEL_IMAGE" != "" ]; then
	write_firmup_state 50 "Update kernel rootfs image"
	update_ki_image $KERNEL_IMAGE 50 70
fi

CAM_ID_PNCODE=`/usr/local/bin/GetPnCodeStr -o19 -l2`
CAM_ID_PNCODE_FIRST=`/usr/local/bin/GetPnCodeStr -o19 -l1`
if [ "$VIDEOCORE_IMAGE" != "" ]; then
	write_firmup_state 70 "Update videocore image"
	update_videocore_image /fw-work/videocore.gz 70 75
fi
cp /fw-work/isp_* /etc
cp /fw-work/hw_* /etc
cp /fw-work/videocoreparamedit /opt/nss/bin
cp /fw-work/param_update.sh /usr/sbin
/fw-work/updatevideocoreparam.sh


#if [[ $CAM_ID_PNCODE_FIRST == 8 ]]; then
	write_firmup_state 80 "Update AI Model"

	/etc/init.d/fweyenixai stop

	MTD_NUM_FOR_AIMODEL=6

	/bin/mountpoint -q /opt/nss/ai

	if [ $? -ne 0 ]; then
		write_firmup_state 80 "Reset AI Model Partition"
		flash_erase /dev/mtd$MTD_NUM_FOR_AIMODEL 0 0

		if [ $? -ne 0 ]; then
				write_firmup_state 80 "Reset AI Model Partition failed"
			sleep 5
		fi

		/bin/mount -t jffs2 /dev/mtdblock$MTD_NUM_FOR_AIMODEL /opt/nss/ai

		if [ $? -ne 0 ]; then
				write_firmup_state 80 "AI Model Partiion mount failed"
			sleep 5
		fi
	fi

	write_firmup_state 85 "Copying AI Model"

	rm -rf /opt/nss/ai/*

	tar zxf /fw-work/fwaimodel.tar.gz -C /opt/nss/ai

	if [ $? -ne 0 ] ; then
			write_firmup_state 85 "Copying AI Model failed"
			sleep 5
	fi
#fi

#if [[ $CAM_ID_PNCODE == "8G" ]] ; then
#	if [ "/fw-work/videocore_SSPR_4.gz" != "" ]; then
#		write_firmup_state 80 "Update videocore image"
#		update_videocore_image /fw-work/videocore_SSPR_4.gz 80 85
#	fi
#elif [[ $CAM_ID_PNCODE == "8D" ]] ; then
#        if [ "/fw-work/videocore_SSPR_8.gz" != "" ]; then
#                write_firmup_state 80 "Update videocore image"
#                update_videocore_image /fw-work/videocore_SSPR_8.gz 80 85
#        fi
#elif [[ $CAM_ID_PNCODE == "8O" ]] ; then
#        if [ "/fw-work/videocore_SSPR_51.gz" != "" ]; then
#                write_firmup_state 80 "Update videocore image"
#                update_videocore_image /fw-work/videocore_SSPR_51.gz 80 85
#        fi
#elif [[ $CAM_ID_PNCODE == "0J" || $CAM_ID_PNCODE == "2J" || $CAM_ID_PNCODE == "3G" ]] ; then
#        if [ "/fw-work/videocore_yuv422.gz" != "" ]; then
#                write_firmup_state 80 "Update videocore image"
#                update_videocore_image /fw-work/videocore_yuv422.gz 80 85
#        fi	
#else
#	if [ "/fw-work/videocore.gz" != "" ]; then
#		write_firmup_state 80 "Update videocore image"
#		update_videocore_image /fw-work/videocore.gz 80 85
#	fi
#fi

SYS_CFG_TMP_FILE=/cfg.tar.gz
NET_CONFIG_RMD=/ncfg.tar.gz
if [ -f "$NET_CONFIG_RMD" ]; then
	write_firmup_state 85 "Set to keep old network configuration"
	echo "[$0] Restore network configuration on next boot"
	/usr/sbin/keepcfg.sh
else
	if [ -f "$SYS_CFG_TMP_FILE" ]; then
		write_firmup_state 85 "Set to keep old system configuration"
		echo "[$0] Restore old system configuration"
		/usr/sbin/keepcfg.sh
	fi
fi

rm /mnt/cfg/.security_debug

write_firmup_state 90 "Update complete. reboot system"

sleep 6

# reboot

exit 0

