#!/bin/sh
#
# F/W update script for ramdisk based FlexWATCH linux system
#
# 							2016-04-21 Gil Jin Yang
#################################################################################

echo "*********************************************************************************"
echo "* F/W update start"
echo "*********************************************************************************"
. /fw-work/fwup-function

CPUID_PNCODE=`/usr/local/bin/GetPnCodeStr -o8 -l1`
OEM_PNCODE=`/usr/local/bin/GetPnCodeStr -o29 -l2`
BINARY_REV="v"
if [ $CPUID_PNCODE == "V" ]; then
	BINARY_REV="uppercase_v"
fi
UBOOT_IMAGE="/fw-work/u-boot_rev-$BINARY_REV.en675.bin"
KERNEL_IMAGE="/fw-work/kernel_rev-$BINARY_REV.en675.gz"
RAMDISK_IMAGE="/fw-work/fwupdatekernelramdisk_rev-$BINARY_REV.en675.gz"
VIDEOCORE_IMAGE="/fw-work/videocore_rev-$BINARY_REV.gz"
#UBOOT_IMAGE=`ls /fw-work/u-boot*.bin | tail -n 1`
#KERNEL_IMAGE=`ls /fw-work/kernel*.gz | tail -n 1`
RSW_IMAGE=`ls /fw-work/rsw*.gz | tail -n 1`
#VIDEOCORE_IMAGE=`ls /fw-work/videocore*.gz | tail -n 1`
#RAMDISK_IMAGE=`ls /fw-work/fwupdatekernelramdisk.en675.gz | tail -n 1`
UPDATEUBOOTFAIL=0
UPDATEKIFAIL=0
UPDATEVIDEOCOREFAIL=0
UPDATERFSFAIL=0
if [ -f "$KERNEL_IMAGE" ]; then
	write_firmup_state 45 "Update kernel image"
	/usr/sbin/mtd_debug erase /dev/mtd3 0 5242880
	update_ki_image $KERNEL_IMAGE 45 49
#	UPDATEKIFAIL=$?
fi

if [ -f "$RAMDISK_IMAGE" ]; then
        write_firmup_state 50 "Update ramdisk image"
	/usr/sbin/mtd_debug erase /dev/mtd4 0 15728640
        update_ri_image $RAMDISK_IMAGE 50 59
#       UPDATEVIDEOCOREFAIL=$?
fi

if [ -f "$VIDEOCORE_IMAGE" ]; then
        write_firmup_state 60 "Update videocore image"
	/usr/sbin/mtd_debug erase /dev/mtd1 0 2097152
        update_videocore_image $VIDEOCORE_IMAGE 60 69
#	UPDATEVIDEOCOREFAIL=$?
fi
cp /fw-work/isp_* /etc
cp /fw-work/hw_* /etc
cp /fw-work/videocoreparamedit /opt/nss/bin
cp /fw-work/param_update.sh /usr/sbin
/fw-work/updatevideocoreparam.sh

/usr/sbin/update_ubi_lnx $RSW_IMAGE

case "$OEM_PNCODE" in
    0W)
        cp -rf /mnt/rfs/etc/oem_def_data/OEM/Wonwoo_WW/* /mnt/rfs/web/
        ;;
    1F|2F)
        cp -rf /mnt/rfs/etc/oem_def_data/OEM/FsNetwork_FN/* /mnt/rfs/web/
        ;;
    30|31|32|33)
        cp -rf /mnt/rfs/etc/oem_def_data/OEM/NoBrand_NB/* /mnt/rfs/web/
        ;;
esac


if [ -f "$UBOOT_IMAGE" ]; then
        write_firmup_state 85 "Update uboot image"
	/usr/sbin/mtd_debug erase /dev/mtd0 0 1048576
        update_uboot_image $UBOOT_IMAGE 85 89
#       UPDATEUBOOTFAIL=$?
fi
#UPDATERFSRAIL=$?
write_firmup_state 90 "Update complete. reboot system"
sleep 6
exit 0

if [ $UPDATEUBOOTFAIL -eq 0 && 
	$UPDATEKIFAIL -eq 0 &&
	$UPDATEVIDEOCOREFAIL -eq 0 &&
	$UPDATERFSRAIL -eq 0 ] ; then
	write_firmup_state 90 "Update complete. reboot system"
	sleep 6
# reboot
	exit 0
else
	exit 3
fi
