#!/bin/sh
source /etc/profile

#==============================================================================================================
#	dev:  size     erasesize name	name	mtd 	Comment					Related Image File [cat /proc/mtd]
#--------------------------------------------------------------------------------------------------------------
#	mtd0: 00020000 00020000 "bst"	BST		mtd0	Bootstrap				(bst_release.bin)
#	mtd1: 00140000 00020000 "bld"	BLD		mtd1	Boot loader				(bld_release.bin) + (s2lm_kiwi.dts_xxxx-xxx.dtb)
#	mtd2: 00140000 00020000 "ptb"	PTB		mtd2	MTD table infomation	(changed by upgrade_patition)
#	mtd3: 00800000 00020000 "pri"	PRI		mtd3	Primary Kernel			(kernel_release.bin)
#	mtd4: 00800000 00020000 "sec"	SEC		mtd4	Secoundary Kernel		(kernel_release.bin)
#	mtd5: 000a0000 00020000 "syst"	SYST	mtd5	Boot Mode				(00 00 00 00)
#	mtd6: 000a0000 00020000 "syft"	SYFT	mtd6	SYFT(Seyeon Flash Table)(syft_release.bin)
#	mtd7: 00200000 00020000 "sycfg"	SYCFG	mtd7	Configuration Backup	(................)
#	mtd8: 02000000 00020000 "rmd"	RMD		mtd8	Ram Disk Image			(rmdisk_1.31-252-ra.gz)
#	mtd9: 0c800000 00020000 "lnx"	LNX		mtd9	Root File System		(lnx_release.bin)
#==============================================================================================================

#==============================================================================================================
# Search for Firmware Update Working Directory
#==============================================================================================================
if [ -d /tmp/fw-work ]; then 
	FirmwareUpdateWorkDir=/tmp/fw-work
else
	if [ -d /fw-work ]; then 
		FirmwareUpdateWorkDir=/fw-work
	else
		echo "[ERROR] Can't find firmware update working dir"
	fi
fi
echo "FirmwareUpdateWorkDir: $FirmwareUpdateWorkDir"

#==============================================================================================================
# source for fwup-function
#	write_firmup_state()
#	make_normal_bootmode()
#	chg_bootmode()
#	update_ramdisk_image()
#	update_kernel_image()
#==============================================================================================================
. ${FirmwareUpdateWorkDir}/fwup-function
. ${FirmwareUpdateWorkDir}/oem_def_hw.sh

#==============================================================================================================
# define UpdateLNXPartition as "update_ubi_lnx" : LNX=NAND Flash Root File System Partition
#	update_ubi_lnx include as followed
#		format_lnx;			//ubidetach ubiformat ubiattach ubimkvol
#		mount_ubi_lnx;		//mount -t ubifs ....
#		update_lnx;			//tar -xvzf $LNX_IN_RMD"
#		upgrade_partition;	//upgrade_partition -q -C "console=ttyS0 ubi.mtd=lnx ~~~~~~~"
#==============================================================================================================
if [ -f $FirmwareUpdateWorkDir/update_ubi_lnx ]; then
	chmod +x update_ubi_lnx;
	UpdateLNXPartition=$FirmwareUpdateWorkDir/update_ubi_lnx
else
	UpdateLNXPartition=/usr/sbin/update_ubi_lnx
fi

#==============================================================================================================
# define upgrade_partition path to UPGRADE_PARTITION
#	upgrade_partition	//C source code => s2l_linux_sdk/ambarella/app/utility/upgrade_partition/
#		usage for upgrade_partition -q -C "AMBOOT Command line syntex"
#		usage for upgrade_partition -q -p MTD# TargetFile
#		usage for upgrade_partition -q -d DTB_FILE
#==============================================================================================================
UPG_VER=`/usr/local/bin/upgrade_partition --version | /bin/grep FlexWATCH | /usr/bin/awk -F '-' '{printf $2}'`
UPGRADE_PARTITION="/fw-work/upgrade_partition"
if [ -f $UPGRADE_PARTITION ]; then
	UPGRADE_PARTITION="/fw-work/upgrade_partition"
else
	UPGRADE_PARTITION="/usr/local/bin/upgrade_partition"
fi

#==============================================================================================================
# print  vfs_cache_pressure, dirty_ratio, dirty_background_ratio
#==============================================================================================================
vm_dir=/proc/sys/vm
echo 160 > $vm_dir/vfs_cache_pressure
echo 5 > $vm_dir/dirty_ratio
echo 5 > $vm_dir/dirty_background_ratio

#==============================================================================================================
# define FW_FILE path
#==============================================================================================================
FW_FILE=`readlink /mnt/rfs/firmwareimage`

#==============================================================================================================
# search RootfsFreeSizeM (Root File System Free Size)
#==============================================================================================================
RootfsFreeSizeM=$(/bin/df -h | /bin/grep root | /usr/bin/awk '{print $4}' | /bin/grep M | /usr/bin/awk -F"." '{print $1}')

#==============================================================================================================
# check RAM Disk Image file in F/W Files
#==============================================================================================================
if [ `ls -l ${FirmwareUpdateWorkDir}/ |grep -c "rsw"` -eq 0 ]; then
	NO_RSW_FILE=1
	printf "[${YELLOW} SKIP ${NC}] Root filesystem update.\n"
else
	NO_RSW_FILE=0
	RSW_FILE=`ls ${FirmwareUpdateWorkDir}/ | grep "rsw" | tail -n 1`
	printf "[${GREEN}START ${NC}] Root filesystem update.\n"
fi

echo "***********************************************"
echo "check if xcmd exists"
echo "***********************************************"
XCMD_FILE=/mnt/rfs/etc/xcmd
if [ -f $XCMD_FILE ]; then
	IFS_backup="$IFS"
	IFS=$'\n'
	XCMD=(`cat $XCMD_FILE`) # save content of xcmd as array
	IFS="$IFS_backup"
	echo "xcmd backed up"
	cat "$XCMD_FILE"
else
	echo "no xcmd"
fi
echo "***********************************************"

#==============================================================================================================
# Prepare Recovery Configuration 
#==============================================================================================================
RFS_CI_IMG=/mnt/rfs/ci.tar.gz
CI_IMG=/tmp/ci.tar.gz

DO_RECOVER_CI_IMG=0

# check if $RFS_CI_IMG exists
if [ -f $RFS_CI_IMG ]; then
	echo "$RFS_CI_IMG exists"
	/bin/gunzip -t $RFS_CI_IMG
	if [ $? -eq 0 ]; then
		echo "$RFS_CI_IMG is OK"
		cp -f $RFS_CI_IMG $CI_IMG
		DO_RECOVER_CI_IMG=1
	else
		echo "$RFS_CI_IMG is NG"
	fi
fi

# if no $RFS_CI_IMG, then read from sycfg partition
if [ "$DO_RECOVER_CI_IMG" -eq 0 ]; then
	echo "try to read cfg data from sycfg parition"
	PartitionName="sycfg"
	MtdNum=`cat /proc/mtd | grep $PartitionName | awk '{print $1}' | sed -e s/^mtd// | sed -e s/\://`
	CI_MTD=/dev/mtd${MtdNum}
	MTD_SIZE=`cat /proc/mtd| grep $PartitionName | awk '{printf $2}'`

	NANDDUMP=/mnt/rfs/usr/sbin/nanddump
	if [ ! -x $NANDDUMP ]; then
		NANDDUMP=/usr/sbin/nanddump
	fi
	echo "NANDDUMP: $NANDDUMP"
	$NANDDUMP -o -f $CI_IMG ${CI_MTD}
	/bin/gunzip -t $CI_IMG
	if [ $? -eq 0 ]; then
		DO_RECOVER_CI_IMG=1
	else
		echo
		printf "${YELLOW}**********************************${NC}\n"
		printf "[${YELLOW}WARN ${NC}] Fail to read backup cfg data from sycfg\n"
		printf "${YELLOW}**********************************${NC}\n"
		echo
	fi
fi

#=======================================================================================================
#Update root filesystem (run $UpdateLNXPartition)
#=======================================================================================================
write_firmup_state 54 "Update rfs : start ..."
chg_bootmode 4
sync
sysctl -w vm.drop_caches=1

$UpdateLNXPartition $RSW_FILE
if [ $? -ne 0 ]; then 
	printf "[${RED}ERROR${NC}] Failed to upgrade LNX partition !!!\n"
	printf "[${RED}ERROR${NC}] Change bootmode ...\n"
	$UpdateLNXPartition -q -C "console=ttyS0 ubi.mtd=lnx root=ubi0:rootfs rw rootfstype=ubifs init=/linuxrc"
	exit -1;
else
	rm $RSW_FILE
	sync
	sysctl -w vm.drop_caches=1
	HW_OPT_NAME=`find_hw_option_name` # defined oem_def_hw.sh
	RSW_FILE="/mnt/rfs/etc/oem_def_data/hw/$HW_OPT_NAME.rsw.tgz"
	if [ -f $RSW_FILE ]; then
		/bin/tar xzf $RSW_FILE -C /mnt/rfs
		echo "$RSW_FILE extracted."
	fi
fi
write_firmup_state 70 "Update rfs : Done"

#=======================================================================================================
# Make default config
#=======================================================================================================
pushd /mnt/rfs > /dev/null
chown -R root:root /mnt/rfs/*
write_firmup_state 75 "Make default config ..."
DEF_CFG=/mnt/rfs/etc/default_conf.tgz
echo
echo "Make default config  "
FILES_TO_COMPRESS=`/mnt/rfs/etc/sy_conf/cfglist2save all`
/bin/tar czf $DEF_CFG $FILES_TO_COMPRESS
printf "[ ${GREEN}Done${NC} ] Make default config\n"
echo
popd > /dev/null


chg_bootmode 5

pushd /mnt/rfs > /dev/null

#==============================================================================================================
# Restore user config at new rfs
#	1. mkdir /tmp/ci_tmp
#	2. tar xzf /tmp/ci.tar.gz -C /tmp/ci_tmp
#	3. cp -a /tmp/ci_tmp/* /mnt/rfs/
#==============================================================================================================
if [ $DO_RECOVER_CI_IMG -eq 1 ]; then
	echo
	printf "${YELLOW}**********************************${NC}\n"
	printf "${YELLOW} Restore user config at new rfs${NC}\n"
	printf "${YELLOW}**********************************${NC}\n"
	echo
	CI_TMP_DIR=/tmp/ci_tmp
	mkdir $CI_TMP_DIR
	/bin/tar xzf $CI_IMG -C $CI_TMP_DIR
	sync
	cp -a $CI_TMP_DIR/* /mnt/rfs/
	[ $? -eq 0 ] && printf "[  ${GREEN}OK${NC}  ] Restore config\n"
	rm -r $CI_TMP_DIR
	sync
fi

# recovery xcmd if it existed
echo "***********************************************"
echo "check and recover xcmd"
echo "***********************************************"
if [ ! -z $XCMD ]; then
	echo "recovery xcmd file"
	rm -f $XCMD_FILE
	for line in "${XCMD[@]}"; do
		echo $line >> $XCMD_FILE
	done
	chmod a+x $XCMD_FILE
	cat $XCMD_FILE
else
	echo "no xcmd backed up"
fi
echo "***********************************************"

rm $CI_IMG
sync


write_firmup_state 80 "Restore ci ... Done"
popd > /dev/null
chg_bootmode 6

#==============================================================================================================
# Upgrade BST Partition (Bootstrap File)
#==============================================================================================================
pushd ${FirmwareUpdateWorkDir}/ > /dev/null
BST_FILE=`ls bst_* | tail -n 1`
if [ -f "$BST_FILE" ]; then
	write_firmup_state 81 "Change bst ..."
	echo
	printf "${YELLOW}**********************************${NC}\n"
	printf "${YELLOW} Change bst: $BST_FILE${NC}\n"
	printf "${YELLOW}**********************************${NC}\n"
	echo
	BST_PART="bst"
	BST_MTD_NUM=`cat /proc/mtd | grep $BST_PART | awk '{print $1}' | sed -e s/^mtd// | sed -e s/\://`
	BST_MTD=/dev/mtd${BST_MTD_NUM}
	/usr/sbin/flash_eraseall $BST_MTD
	${UPGRADE_PARTITION} -q -p $BST_MTD $BST_FILE 
	if [ $? -ne 0 ]; then
		${UPGRADE_PARTITION} -q -p $BST_MTD $BST_FILE 
		if [ $? -ne 0 ]; then
			printf "[${RED}Failed${NC}] Change bst\n"
		fi
	else
		printf "[  ${GREEN}OK${NC}  ] Change bst\n"
	fi
fi
sync
chg_bootmode 7

#==============================================================================================================
# Upgrade BLD Partition (Boot Loader "amboot")
#==============================================================================================================
BLD_FILE=`ls bld_* | tail -n 1`
if [ -f "$BLD_FILE" ]; then
	write_firmup_state 82 "Change bld ..."
	echo
	printf "${YELLOW}**********************************${NC}\n"
	printf "${YELLOW} Change bld: $BLD_FILE${NC}\n"
	printf "${YELLOW}**********************************${NC}\n"
	echo
	BLD_PART="bld"
	BLD_MTD_NUM=`cat /proc/mtd | grep $BLD_PART | awk '{print $1}' | sed -e s/^mtd// | sed -e s/\://`
	BLD_MTD=/dev/mtd${BLD_MTD_NUM}
	/usr/sbin/flash_eraseall $BLD_MTD
	${UPGRADE_PARTITION} -q -p $BLD_MTD $BLD_FILE
	if [ $? -ne 0 ]; then
		write_firmup_state 83 "[ERROR] Failed to write BLD"
		printf "[${RED}ERROR${NC}] Failed to write BLD Partition!!!\n"
		printf "[${RED}ERROR${NC}] run upgrade_partition again...\n"
		/usr/sbin/flash_eraseall $BLD_MTD
		${UPGRADE_PARTITION} -q -p $BLD_MTD $BLD_FILE 
		if [ $? -ne 0 ]; then
			printf "[${RED}Failed${NC}] Change bld\n"
		fi
		sleep 3
	else
		printf "[  ${GREEN}OK${NC}  ] Change bld\n"
	fi
fi
sync
chg_bootmode 8

#==============================================================================================================
# Upgrade AMBOOT FDT as .dtb file in BDL Partition (s2lm_kiwi.dts_xxxx-xxx.dtb)
#==============================================================================================================
HW_OPT_NAME=`find_hw_option_name` # defined oem_def_hw.sh
if [ -z $HW_OPT_NAME ]; then
 	HW_OPT_NAME=s2lm_kiwi
fi
DTB_FILE=`ls $HW_OPT_NAME.dts_* | tail -n 1`
if [ $HW_OPT_NAME != "s2lm_kiwi" ]; then
DTB_FILE="/mnt/rfs/etc/oem_def_data/hw/$HW_OPT_NAME.dts.dtb"
fi
if [ -f "$DTB_FILE" ]; then
 	write_firmup_state 82 "Change dts ..."
 	echo
 	printf "${YELLOW}**********************************${NC}\n"
 	printf "${YELLOW} Change dtb: $DTB_FILE${NC}\n"
 	printf "${YELLOW}**********************************${NC}\n"
 	echo
 	${UPGRADE_PARTITION} -q -d $DTB_FILE 
 	[ $? -eq 0 ] && printf "[  ${GREEN}OK${NC}  ] Change dtb\n"
fi
chg_bootmode 9

#==============================================================================================================
# Update Kernel Image (ki)
#==============================================================================================================
update_kernel_image ${FirmwareUpdateWorkDir}
chg_bootmode 10

#==============================================================================================================
# Update Backup Kernel Image (bki)
#==============================================================================================================
BKI_FILE=`find -name "RMD_KImage_*" | tail -n 1`
if [ "$BKI_FILE" != "" -a -f "$BKI_FILE" ]; then
	write_firmup_state 85 "Change bki ..."
	echo
	printf "${YELLOW}**********************************${NC}\n"
	printf "${YELLOW} Change bki $BKI_FILE${NC}\n"
	printf "${YELLOW}**********************************${NC}\n"
	echo
	/usr/sbin/chgki $BKI_FILE "sec" > /dev/null
	[ $? -eq 0 ] && printf "[  ${GREEN}OK${NC}  ] Change bki\n"
else
	printf "${YELLOW} Skip update bki...${NC}\n"
fi
chg_bootmode 11

#==============================================================================================================
# Update RAM Disk Image
#==============================================================================================================
update_ramdisk_image ${FirmwareUpdateWorkDir}
chg_bootmode 12

sync

#==============================================================================================================
# Make Normal Boot Mode
#==============================================================================================================
make_normal_bootmode
write_firmup_state 90 "F/W Update complete."

popd > /dev/null

FWUPDATEPOST_FLAG=/fwupdate_done
/bin/touch $FWUPDATEPOST_FLAG
sync
# for web-polling
sleep 6

