#!/bin/sh

# HW_OPT_FIELDS 와 HW_OPT_LIST: 하드웨어 옵션들을 관리하기 위한 데이터 구성
## HW_OPT_FIELDS 이 "39:2,43:1" 이고, 
## HW_OPT_LIST 가 다음과 같은 경우
### 04,1 hw1
### 10,2 hw2
# pncode 에 따른 하드웨어 옵션 이름은 다음과 같음
## pncode 의 39-40 번째가 "04" 이고, 43번째 문자가 "1" 이면 hw1 파일
## pncode 의 39-40 번째가 "10" 이고, 43번째 문자가 "2" 이면 hw2 파일
# HW_OPT_FIELDS: 하드웨어 옵션을 구성하는 pncode 상의 필드들의 정보.
## 각 필드는 pncode 의 offset:length 포맷을 가지고, 필드들은 콤마(,) 로 구분
## (ex) 39:2,43:1 => pncode 의 39 번째부터 2개 문자열, pncode 의 43 번째 문자
# HW_OPT_LIST: 하드웨어 옵션들의 목록
## 각 라인은 필드값들과 하드웨어 옵션 이름.
## value1,value2,... hw_option_name
## (ex) 0A,2 abc
## 첫번째 필드값은 0A, 두번째 필드값이 2 인 하드웨어 옵션의 이름은 abc

HW_OPT_FIELDS="43:1"
HW_OPT_LIST="
0 s2lm_kiwi
1 s2lm_kiwi
2 kdo
Z kmw
"

function get_string_index() {
	# Returns the index of $2 in $1. If not found, then returns -1
	# Exam. get_string_index "123456789" "6789" -> returns 5
	#       get_string_index "123456789" "356" -> return -1
	local x="${1%%$2*}"
	[[ "$x" = "$1" ]] && echo -1 || echo "${#x}"
}

function get_option_value_of_pncode() {
	local pncode="$1"
	local option_field="$2" # (ex) "43:1"
	local seperator=":"
	local pos_of_sep=`get_string_index $option_field $seperator` # (ex) 2
	if [ $pos_of_sep -lt 0 ]; then
		echo ""
		return
	fi

	local start=`echo ${option_field:0:$pos_of_sep}` # (ex) 43
	local length=${option_field:$pos_of_sep+1} # (ex) 1
	spcp $start $length
}

function get_hw_option_values() {
	local pncode="$1"
	local option_fields=`echo $2 | tr ',' ' '`
	local hw_option_values=""
	for f in $option_fields; do
		local v=`get_option_value_of_pncode $pncode $f`
		if [ -z $v ]; then
			return
		fi
		if [ -z $hw_option_values ]; then
			hw_option_values="$v"
		else
			hw_option_values="$hw_option_values,$v"
		fi
	done
	echo $hw_option_values
}

function find_hw_option_name() {
    if [ -z "$HW_OPT_FIELDS" ]; then
        return
    fi
	local pncode=`syft.st -r 1 | awk -F'=' '{print $2}' | tr -d ' '`
	local option_values_from_pncode=`get_hw_option_values $pncode "$HW_OPT_FIELDS"`
	echo -e "$HW_OPT_LIST" | while IFS= read -r line; do
		local values=`echo "$line" | awk '{print $1}'`
		if [ "$values" == "$option_values_from_pncode" ]; then
			echo "$line" | awk '{print $2}'
			return
		fi
	done
}
